
<?php
// 1. Conexión a la BD
 $servername = "localhost";
    $username = "supervisor";
    $password = "Pinpad2021";
    $dbname = "cnjs_jptgi";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Error de conexión a la base de datos: " . $conn->connect_error);
}

// 2. Recibimos los datos del formulario
$doi_original     = isset($_POST['doi_original']) ? trim($_POST['doi_original']) : '';
$doi              = isset($_POST['doi']) ? trim($_POST['doi']) : '';
$nombre           = isset($_POST['nombre']) ? trim($_POST['nombre']) : '';
$apellido1        = isset($_POST['apellido1']) ? trim($_POST['apellido1']) : '';
$apellido2        = isset($_POST['apellido2']) ? trim($_POST['apellido2']) : '';
$fecha_nacimiento = isset($_POST['fecha_nacimiento']) ? trim($_POST['fecha_nacimiento']) : '';
$lugar_nacimiento = isset($_POST['lugar_nacimiento']) ? trim($_POST['lugar_nacimiento']) : '';
$nacionalidad     = isset($_POST['nacionalidad']) ? trim($_POST['nacionalidad']) : '';
$email            = isset($_POST['email']) ? trim($_POST['email']) : '';
$observaciones    = isset($_POST['observaciones']) ? trim($_POST['observaciones']) : '';
$tipo_canje       = isset($_POST['tipo_canje']) ? trim($_POST['tipo_canje']) : '';
$via              = isset($_POST['via']) ? (int)$_POST['via'] : 1;
$gestoria         = isset($_POST['gestoria']) ? trim($_POST['gestoria']) : '';

// 3. Convertimos fecha_nacimiento (dd/mm/yyyy) a formato yyyy-mm-dd para guardar
if (!empty($fecha_nacimiento)) {
    $partes = explode('/', $fecha_nacimiento);
    if (count($partes) === 3) {
        // dd/mm/yyyy -> yyyy-mm-dd
        $fecha_nacimiento = $partes[2] . '-' . $partes[1] . '-' . $partes[0];
    } else {
        $fecha_nacimiento = null;
    }
} else {
    $fecha_nacimiento = null;
}

// 4. Preparamos el UPDATE
$sql = "UPDATE exp_data
        SET 
            DOI = ?,
            NOMBRE = ?,
            APELLIDO_1 = ?,
            APELLIDO_2 = ?,
            FECHA_NACIMIENTO = ?,
            P_NACIMIENTO = ?,
            NACIONALIDAD = ?,
            EMAIL = ?,
            OBSERVACIONES = ?,
            TIPO_CANJE = ?,
            VIA = ?,
            gestoria = ?
        WHERE DOI = ?";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Error al preparar la consulta: " . $conn->error);
}

// 5. Asociamos parámetros
$stmt->bind_param(
    'sssssssssssis',
    $doi,
    $nombre,
    $apellido1,
    $apellido2,
    $fecha_nacimiento,
    $lugar_nacimiento,
    $nacionalidad,
    $email,
    $observaciones,
    $tipo_canje,
    $via,
    $gestoria,
    $doi_original
);

// 6. Ejecutamos
if ($stmt->execute()) {
    // Éxito: redireccionamos a la página donde se ve el expediente, por ejemplo
    header("Location: ../../exp/?doi=" . urlencode($doi));
    exit;
} else {
    echo "Error al actualizar los datos: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>

