<?php
// Obtiene el DOI de la variable GET y lo almacena en una variable PHP
$doi = isset($_GET['doi']) ? htmlspecialchars($_GET['doi']) : '';
?>
<?php
// Iniciar la sesión
session_start();

// Verificar si la sesión 'userjpt' está abierta
if (isset($_SESSION['userjpt'])) {
    // Guardar el valor de la sesión en una variable
    $nombreUsuario = $_SESSION['userjpt'];
} else {
    // Si no hay sesión activa, redirigir a Google
    header('Location: https://10.50.17.50/intra/');
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SWAP - CANJES</title>
    <!-- Cargar CSS de Bootstrap -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h2>Borrado de Expediente del Sys. SWAP</h2>
    <form method="GET" action="http://10.50.17.50/swap/tram/del/del.php" onsubmit="return confirmBorrado()" class="needs-validation" novalidate>
        <!-- Campo DOI (bloqueado) -->
        <div class="form-group">
            <label for="doi">DOI</label>
            <input type="text" class="form-control" id="doi" name="doi" value="<?php echo $doi; ?>" readonly required>
        </div>

        <!-- Campo USER -->
        <div class="form-group">
            <label for="user">Usuario:</label>
<input 
    type="text" 
    class="form-control" 
    id="user" 
    name="user" 
    maxlength="9" 
    pattern="\d{1,9}" 
    value="<?= htmlspecialchars($nombreUsuario, ENT_QUOTES, 'UTF-8'); ?>" 
    required 
    aria-describedby="userHelp"
 readonly>
<small id="userHelp" class="form-text text-muted">
    Ingrese hasta 9 dígitos numéricos.
</small>
            <div class="invalid-feedback">
                Por favor ingrese un número de usuario válido (hasta 9 dígitos).
            </div>
            <br>
            <label>Una vez aceptada, se procederá con la eliminación definitiva del expediente en la base de datos del sistema SWAP, registrándose el usuario que ha ejecutado esta acción. Es importante tener en cuenta que esta operación es irreversible y no permitirá la recuperación de los datos eliminados.</label>
        </div>

        <!-- Botón de envío -->
        <button type="submit" class="btn btn-danger">Firmo y Acepto</button>
    </form>
</div>

<!-- Script de JavaScript para validación y confirmación -->
<script>
    // Función para mostrar el mensaje de confirmación
    function confirmBorrado() {
        return confirm("Se va a realizar el borrado. ¿Está seguro de que desea continuar?");
    }

    // Habilitar la validación personalizada de Bootstrap
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            var forms = document.getElementsByClassName('needs-validation');
            Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
</script>

<!-- Cargar JavaScript de Bootstrap y jQuery (opcional) -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
