<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sistema de Gestión Documental para Oficio">
    <title>SGDO</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #34495e;
        }
        
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        }
        
        .navbar-brand {
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .main-title {
            color: var(--primary-color);
            border-bottom: 3px solid var(--primary-color);
            display: inline-block;
            padding-bottom: 0.5rem;
        }
        
        .card {
            border: none;
            transition: transform 0.2s;
            margin-bottom: 2rem;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            background-color: var(--primary-color);
            border-bottom: none;
            border-radius: 8px 8px 0 0 !important;
        }
        
        .btn-custom {
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 6px;
            transition: all 0.3s;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 1rem;
            width: 100%;
        }
        
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }

        .countries-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 2rem;
            padding: 1rem;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark" style="background-color: var(--primary-color);">
        <div class="container">
            <a class="navbar-brand" href="#">
                SGDO - SWAP CANJES
            </a>
        </div>
    </nav>
       <div class="container mt-5">
        <div class="text-center mb-5">
            <h1 class="main-title display-5 fw-bold">Oficios de Canjes</h1>
            <p class="text-muted mt-3">Sistema de Generación Documental de Oficios</p>
        </div>
        <div class="countries-grid">

<?php

// Configuración para mostrar errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuración de la conexión a la base de datos
$host = "localhost";  // o la dirección de tu servidor
$usuario = "supervisor";  // tu usuario de la base de datos
$password = "Pinpad2021";  // tu contraseña de la base de datos
$base_datos = "cnjs_jptgi";  // nombre de tu base de datos

$doi = 123;

// Establecer la conexión
$conexion = mysqli_connect($host, $usuario, $password, $base_datos);

// Verificar la conexión
if (!$conexion) {
    die("Error de conexión: " . mysqli_connect_error());
}

// Establecer el conjunto de caracteres
mysqli_set_charset($conexion, "utf8");

// Realizamos la consulta a la tabla
$query = "SELECT pais, residencia, 185dias, pc_rechazado, edad, categoria, canjes_3_pais 
          FROM SGDO";
$resultado = mysqli_query($conexion, $query);

// Verificamos si hay resultados
if(mysqli_num_rows($resultado) > 0) {
    // Iteramos sobre cada fila
    while($row = mysqli_fetch_assoc($resultado)) {
        ?>
        <div class="card shadow-lg">
            <div class="card-header py-3">
                <h3 class="text-white mb-0 text-center fw-bold"><?php echo htmlspecialchars($row['pais']); ?></h3>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                   <?php
// Verificamos que $row sea un array válido y las claves existan
if (is_array($row)) {

    // Botón de RESIDENCIA
    if (!empty($row['residencia'])) {
        ?>
        <a href="delega.php?doi=<?php echo urlencode($doi); ?>&ofid=<?php echo urlencode($row['edad']); ?>" 
           class="btn btn-custom btn-danger">
            RESIDENCIA
        </a>
        <?php
    }

    // Botón de NO ACREDITA 185 DÍAS
    if (!empty($row['185dias'])) {
        ?>
        <a href="delega.php?doi=<?php echo urlencode($doi); ?>&ofid=<?php echo urlencode($row['edad']); ?>" 
           class="btn btn-custom btn-primary">
            NO ACREDITA 185 DÍAS
        </a>
        <?php
    }

    // Botón de PC RECHAZADO BRAZIL
    if (!empty($row['pc_rechazado'])) {
        ?>
        <a href="delega.php?doi=<?php echo urlencode($doi); ?>&ofid=<?php echo urlencode($row['pc_rechazado']); ?>" 
           class="btn btn-custom btn-warning">
            PC RECHAZADO BRAZIL
        </a>
        <?php
    }

    // Botón de EDAD NO REGLAMENTARIA
    if (!empty($row['edad'])) {
        ?>
        <a href="delega.php?doi=<?php echo urlencode($doi); ?>&ofid=<?php echo urlencode($row['edad']); ?>" 
           class="btn btn-custom btn-dark">
            EDAD NO REGLAMENTARIA
        </a>
        <?php
    }

} else {
    // Manejo de error si $row no es un array válido
    echo '<p>Error: Datos no válidos.</p>';
}
?>

                </div>
            </div>
        </div>
        <?php
    }
} else {
    echo "<p>No se encontraron registros</p>";
}

// Cerramos la conexión
mysqli_close($conexion);
?>

   </div>
    </div>

    <footer class="mt-5 py-3 text-center text-muted">
        <small>© 2025 SWAP CANJES. Todos los derechos reservados.</small>
    </footer>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/js/all.min.js"></script>
</body>
</html>