<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar conexión
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Consulta SQL con preparación
$sql = "SELECT * FROM reg_oficios WHERE DOI=? ORDER BY id ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $doi);

// Obtener el DOI desde la solicitud (con sanitización básica)
$doi = htmlspecialchars($_GET['doi'] ?? '', ENT_QUOTES, 'UTF-8');
$stmt->execute();
$result = $stmt->get_result();
?>

<table class="table table-striped">
    <tr>
        <th>Tipo</th>
        <th>Permiso</th>
        <th>Fecha</th>
        <th>País</th>
        <th>Acciones</th>
    </tr>
    <?php if ($result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
            <?php
            $fecha = date("d/m/Y", strtotime($row["denegatoria_enviada"]));
            $tipo = $row['denegatoria'];
            $url = '';
           
            ?>
            <tr>
                <td><?= htmlspecialchars($tipo) ?></td>
            	<td><?= htmlspecialchars($row["categoria"]) ?></td>
                <td><?= htmlspecialchars($fecha) ?></td>
                <td><?= htmlspecialchars($row["pais"]) ?></td>
                <td>
                   <!-- <button class="btn btn-success" onclick="window.location.href='../tram/exam/<?= htmlspecialchars($url) ?>'">Ver Examen</button> 
                    <button class="btn btn-danger" onclick="window.location.href='../tram/exam/del.php?id=<?= htmlspecialchars($row['id']) ?>'">Eliminar</button>--!>
                </td>
            </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr>
            <td colspan="4">No se encuentra registrado ningún trámite</td>
        </tr>
    <?php endif; ?>
</table>

<!-- Botón para añadir examen -->
<!--
<button class="btn btn-primary" data-url="../tram/exam/form-teo.php?doi=<?php echo $doi; ?>">Añadir Teórico</button>
<button class="btn btn-primary" data-url="../tram/exam/form-circ.php?doi=<?php echo $doi; ?>">Añadir Circulación</button>
<button class="btn btn-primary" onclick="window.location.href='../tram/exam/form-teo.php?doi=<?php echo $doi; ?>'">Añadir Destreza</button>
--!>
<script>   
document.querySelectorAll('.btn[data-url]').forEach(button => {
    button.addEventListener('click', function () {
        const url = this.getAttribute('data-url');
        if (url) {
            window.location.href = url;
        }
    });
});
</script>

<br><br>

<?php
// Cerrar la conexión
$conn->close();
?>
