<?php
// Asegurarse de tener conexión activa
if (!isset($conn) || $conn->connect_error) {
    mostrarError("Error de conexión: " . $conn->connect_error);
    exit();
}

if (!isset($doi)) {
    mostrarError("El DOI no está definido.");
    exit();
}

$doi = $conn->real_escape_string($doi);

// Consulta SQL segura
$sql = $conn->prepare("SELECT * FROM reg_anot WHERE doi = ? ORDER BY fecha ASC");
if (!$sql) {
    mostrarError("Error en la preparación de la consulta: " . $conn->error);
    exit();
}
$sql->bind_param("s", $doi);
$sql->execute();
$result = $sql->get_result();

// Configurar fecha en español
setlocale(LC_TIME, 'es_ES.UTF-8');
?>
<!-- Observaciones o Anotaciones -->
<div class="col-12">
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="fas fa-comments me-2"></i>Observaciones</h5>
            <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#observacionesModal">
                <i class="fas fa-plus me-1"></i> Añadir Observación
            </button>
        </div>
        <div class="card-body py-3">
            <?php if ($result->num_rows > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 120px;"><i class="fas fa-calendar-day me-1"></i>Fecha</th>
                                <th><i class="fas fa-comment-alt me-1"></i>Anotación</th>
                                <th class="text-center" style="width: 80px;"><i class="fas fa-cogs me-1"></i></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()):
                                $fecha = date("d/m/Y", strtotime($row["fecha"]));
                                $id = htmlspecialchars($row["id"]);
                                $anotacion = htmlspecialchars($row["text"]);
                            ?>
                            <tr>
                                <td><?= $fecha ?></td>
                                <td><?= nl2br($anotacion) ?></td>
                                <td class="text-center">
                                    <button class="btn btn-outline-danger btn-sm btn-acciones" data-bs-toggle="modal" data-bs-target="#confirmDeleteModal<?= $id ?>" title="Eliminar">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>

                                    <!-- Modal eliminación -->
                                    <div class="modal fade" id="confirmDeleteModal<?= $id ?>" tabindex="-1" aria-labelledby="confirmDeleteModalLabel<?= $id ?>" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header bg-danger text-white">
                                                    <h5 class="modal-title" id="confirmDeleteModalLabel<?= $id ?>"><i class="fas fa-exclamation-triangle me-2"></i>Confirmar eliminación</h5>
                                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    ¿Está seguro de que desea eliminar esta observación?
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                    <a href="<?= '../tram/observ/del.php?id=' . $id . '&doi=' . urlencode($doi) ?>" class="btn btn-danger">Eliminar</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info mb-0"><i class="fas fa-info-circle me-2"></i>No se han registrado observaciones.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal: Añadir observación -->
<div class="modal fade" id="observacionesModal" tabindex="-1" aria-labelledby="observacionesModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <form method="POST" action="../tram/observ/add.php" class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="observacionesModalLabel"><i class="fas fa-plus me-2"></i>Nueva Observación</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="doi" value="<?= htmlspecialchars($doi) ?>">

                <div class="mb-3">
                    <label for="fecha" class="form-label">Fecha</label>
                    <input type="date" name="fecha" id="fecha" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label for="text" class="form-label">Texto de la observación</label>
                    <textarea name="text" id="text" class="form-control" rows="4" required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-primary">Guardar</button>
            </div>
        </form>
    </div>
</div>
