<?php
// Configuración de la base de datos
define('DB_HOST', 'localhost');
define('DB_USER', 'supervisor');
define('DB_PASS', 'Pinpad2021'); // Considera usar variables de entorno para credenciales
define('DB_NAME', 'vigex_jptgi');

// Función para conectar a la base de datos
function conectarDB() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    $conn->set_charset("utf8mb4");
    
    if ($conn->connect_error) {
        mostrarError("Error de conexión: " . $conn->connect_error);
        exit();
    }

    return $conn;
}

// Función para mostrar errores
function mostrarError($mensaje) {
    echo "<div class='alert alert-danger'><i class='fas fa-exclamation-triangle me-2'></i>{$mensaje}</div>";
}

// Función para mostrar mensajes de éxito
function mostrarExito($mensaje) {
    echo "<div class='alert alert-success'><i class='fas fa-check-circle me-2'></i>{$mensaje}</div>";
}

// Función para obtener datos del expediente
function obtenerExpediente($doi) {
    $conn = conectarDB();
    $doi = $conn->real_escape_string($doi);

    $sql = "SELECT * FROM exp_data WHERE doi = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $doi);
    $stmt->execute();

    $resultado = $stmt->get_result();

    if ($resultado && $resultado->num_rows > 0) {
        return $resultado->fetch_assoc();
    }

    $stmt->close();
    $conn->close();

    return null;
}

// Función para formatear fechas al estilo dd-mm-yyyy
function formatearFecha($fecha) {
    return (!empty($fecha) && strtotime($fecha)) ? date('d-m-Y', strtotime($fecha)) : '';
}

function mostrarCampo($datos, $campo) {
    $valor = isset($datos[$campo]) ? $datos[$campo] : '';
    if (empty($valor)) {
        return '<span class="text-muted">No especificado</span>';
    }

    // Campos que deben formatearse como fecha
    $camposFecha = ['fecha_nacimiento', 'fecha_modificacion', 'vigencia_grupo1', 'vigencia_grupo2'];

    if (in_array($campo, $camposFecha)) {
        $valor = formatearFecha($valor);
    }

    return htmlspecialchars($valor);
}

// Función para formatear nombre de campo
function formatearCampo($campo) {
    $campo = str_replace(['_', '1', '2'], [' ', ' principal', ' alternativa'], $campo);
    return ucfirst($campo);
}

// Verificar si se recibió el DOI
if (!isset($_GET['doi']) || empty($_GET['doi'])) {
    mostrarError("No se ha especificado un identificador de expediente válido.");
    exit();
}

$doi = $_GET['doi'];
$expediente = obtenerExpediente($doi);

if (!$expediente) {
    mostrarError("No se encontró ningún expediente con el identificador proporcionado.");
    exit();
}

// Definición de los grupos de campos
$gruposCampos = [
    'datos_personales' => ['doi', 'nombre', 'apellido1', 'apellido2', 'fecha_nacimiento', 'telefono', 'email'],
    'direccion_principal' => ['tipo_via1', 'nombre_via1', 'numero1', 'bloque1', 'portal1', 'escalera1', 'planta1', 'puerta1', 'km1', 'cp1', 'provincia1', 'municipio1', 'localidad1'],
    'direccion_alternativa' => ['tipo_via2', 'nombre_via2', 'numero2', 'bloque2', 'portal2', 'escalera2', 'planta2', 'puerta2', 'km2', 'cp2', 'provincia2', 'municipio2', 'localidad2'],
    'permisos_grupo1' => ['grupo1', 'vigencia_grupo1', 'clases_grupo1'],
    'permisos_grupo_2' => ['grupo2', 'vigencia_grupo2', 'clases_grupo2'],
];

// Datos adicionales
$estadoExpediente = isset($expediente['estado']) ? $expediente['estado'] : 'En proceso';
$ultimaModificacion = isset($expediente['fecha_modificacion']) ? formatearFecha($expediente['fecha_modificacion']) : 'Desconocida';
$usuarioModificacion = isset($expediente['usuario_modificacion']) ? $expediente['usuario_modificacion'] : 'Sistema';

// Nombre completo del titular
$nombreCompleto = trim("{$expediente['nombre']} {$expediente['apellido1']} {$expediente['apellido2']}");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Expedientes - <?= htmlspecialchars($nombreCompleto) ?></title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .expediente-header {
            background-color: #f8f9fa;
            border-left: 4px solid #0d6efd;
        }
        .accordion-button:not(.collapsed) {
            background-color: #e7f1ff;
            color: #0d6efd;
        }
        .campo-label {
            font-weight: 600;
            color: #495057;
        }
        .badge-estado {
            font-size: 0.9rem;
        }
        .btn-acciones {
            width: 38px;
            height: 38px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        .timeline-item {
            position: relative;
            padding-left: 28px;
            border-left: 2px solid #dee2e6;
        }
        .timeline-dot {
            position: absolute;
            left: -9px;
            width: 16px;
            height: 16px;
            border-radius: 50%;
            background: #0d6efd;
        }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="row g-4">
            <!-- Columna izquierda - Información principal -->
                <div class="card shadow-sm mb-4">
                      
                    <div class="card-body p-0">
                        <div class="accordion" id="expedienteAccordion">
                            <?php
                            $i = 0;
                            foreach ($gruposCampos as $grupo => $campos) {
                                $i++;
                                $iconos = [
                                    'datos_personales' => 'fa-user',
                                    'direccion_principal' => 'fa-home',
                                    'direccion_alternativa' => 'fa-building',
                                    'permisos_grupo1' => 'fa-id-card',
                                    'permisos_grupo2' => 'fa-id-badge',
                                    'documentacion' => 'fa-file-alt'
                                ];
                                
                                $icono = isset($iconos[$grupo]) ? $iconos[$grupo] : 'fa-list';
                                $mostrarGrupo = $i <= 3 ? 'show' : '';
                                $expandido = $i <= 3 ? '' : 'collapsed';
                                
                                $titulo = str_replace('_', ' ', $grupo);
                                $titulo = ucwords($titulo);
                            ?>
                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button <?= $expandido ?>" type="button" data-bs-toggle="collapse" data-bs-target="#<?= $grupo ?>">
                                            <i class="fas <?= $icono ?> me-2"></i><?= $titulo ?>
                                        </button>
                                    </h2>
                                    <div id="<?= $grupo ?>" class="accordion-collapse collapse <?= $mostrarGrupo ?>" data-bs-parent="#expedienteAccordion">
                                        <div class="accordion-body">
                                            <div class="row">
                                                <?php foreach ($campos as $campo) { ?>
                                                    <div class="col-md-6 mb-3">
                                                        <div class="d-flex">
                                                            <span class="campo-label me-2"><?= formatearCampo($campo) ?>:</span>
                                                            <span><?= mostrarCampo($expediente, $campo) ?></span>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                
                
            
            <!-- Columna derecha - Información adicional -->
           
                <!-- Panel de acciones rápidas -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0"><i class="fas fa-bolt me-2"></i>Acciones rápidas</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-2">
                            <button class="btn btn-outline-primary btn-acciones" title="Enviar correo" data-bs-toggle="tooltip">
                                <i class="fas fa-envelope"></i>
                            </button>
                            <button class="btn btn-outline-primary btn-acciones" title="Añadir nota" data-bs-toggle="tooltip">
                                <i class="fas fa-sticky-note"></i>
                            </button>
                            <button class="btn btn-outline-primary btn-acciones" title="Subir documento" data-bs-toggle="tooltip">
                                <i class="fas fa-file-upload"></i>
                            </button>
                            <button class="btn btn-outline-primary btn-acciones" title="Cambiar estado" data-bs-toggle="tooltip">
                                <i class="fas fa-tasks"></i>
                            </button>
                            <button class="btn btn-outline-primary btn-acciones" title="Añadir tarea" data-bs-toggle="tooltip">
                                <i class="fas fa-check-square"></i>
                            </button>
                            <button class="btn btn-outline-primary btn-acciones" title="Descargar documentos" data-bs-toggle="tooltip">
                                <i class="fas fa-file-download"></i>
                            </button>
                        </div>
                            <div>
                        <button type="button" class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#modalEditar">
                            <i class="fas fa-edit me-2"></i>Editar expediente
                        </button>
                        <button type="button" class="btn btn-outline-primary me-2" onclick="imprimirExpediente()">
                            <i class="fas fa-print me-2"></i>Imprimir
                        </button>
                    </div>
                    <div>
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#modalEliminar">
                            <i class="fas fa-trash-alt me-2"></i>Eliminar
                        </button>
                    </div>
                    </div>
                </div>
                            <!-- Botones de acción -->
                <div class="d-flex justify-content-between mb-4">
                    <div>
                        <button type="button" class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#modalEditar">
                            <i class="fas fa-edit me-2"></i>Editar expediente
                        </button>
                        <button type="button" class="btn btn-outline-primary me-2" onclick="imprimirExpediente()">
                            <i class="fas fa-print me-2"></i>Imprimir
                        </button>
                    </div>
                    <div>
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#modalEliminar">
                            <i class="fas fa-trash-alt me-2"></i>Eliminar
                        </button>
                    </div>
                </div>
            </div>
                
                
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal de edición de expediente -->
    <div class="modal fade" id="modalEditar" tabindex="-1" aria-labelledby="modalEditarLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalEditarLabel">Editar expediente</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="formEditar" action="procesar_expediente.php" method="POST">
                        <input type="hidden" name="doi" value="<?= htmlspecialchars($expediente['doi']) ?>">
                        
                        <ul class="nav nav-tabs mb-4" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="personal-tab" data-bs-toggle="tab" data-bs-target="#personal" type="button" role="tab" aria-controls="personal" aria-selected="true">Datos personales</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="direccion-tab" data-bs-toggle="tab" data-bs-target="#direccion" type="button" role="tab" aria-controls="direccion" aria-selected="false">Direcciones</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="permisos-tab" data-bs-toggle="tab" data-bs-target="#permisos" type="button" role="tab" aria-controls="permisos" aria-selected="false">Permisos</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="documentos-tab" data-bs-toggle="tab" data-bs-target="#documentos" type="button" role="tab" aria-controls="documentos" aria-selected="false">Documentación</button>
                            </li>
                        </ul>
                        
                        <div class="tab-content" id="myTabContent">
                            <!-- Tab Datos Personales -->
                            <div class="tab-pane fade show active" id="personal" role="tabpanel" aria-labelledby="personal-tab">
                                <div class="row g-3">
                                    <div class="col-md-4">
                                        <label for="nombre" class="form-label">Nombre</label>
                                        <input type="text" class="form-control" id="nombre" name="nombre" value="<?= htmlspecialchars($expediente['nombre']) ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="apellido1" class="form-label">Primer apellido</label>
                                        <input type="text" class="form-control" id="apellido1" name="apellido1" value="<?= htmlspecialchars($expediente['apellido1']) ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="apellido2" class="form-label">Segundo apellido</label>
                                        <input type="text" class="form-control" id="apellido2" name="apellido2" value="<?= htmlspecialchars($expediente['apellido2']) ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="fecha_nacimiento" class="form-label">Fecha de nacimiento</label>
                                        <input type="date" class="form-control" id="fecha_nacimiento" name="fecha_nacimiento" value="<?= date('d-m-Y', strtotime($expediente['fecha_nacimiento'])) ?>
">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="telefono" class="form-label">Teléfono</label>
                                        <input type="tel" class="form-control" id="telefono" name="telefono" value="<?= htmlspecialchars($expediente['telefono']) ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" class="form-control" id="email" name="email" value="<?= htmlspecialchars($expediente['email']) ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="estado" class="form-label">Estado expediente</label>
                                        <select class="form-select" id="estado" name="estado">
                                            <option value="En proceso" <?= $estadoExpediente == 'En proceso' ? 'selected' : '' ?>>En proceso</option>
                                            <option value="Pendiente" <?= $estadoExpediente == 'Pendiente' ? 'selected' : '' ?>>Pendiente</option>
                                            <option value="Completado" <?= $estadoExpediente == 'Completado' ? 'selected' : '' ?>>Completado</option>
                                            <option value="Rechazado" <?= $estadoExpediente == 'Rechazado' ? 'selected' : '' ?>>Rechazado</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Aquí irían los demás tabs con sus respectivos campos -->
                            <div class="tab-pane fade" id="direccion" role="tabpanel" aria-labelledby="direccion-tab">
                                <!-- Campos de dirección principal y alternativa -->
                            </div>
                            
                            <div class="tab-pane fade" id="permisos" role="tabpanel" aria-labelledby="permisos-tab">
                                <!-- Campos de permisos -->
                            </div>
                            
                            <div class="tab-pane fade" id="documentos" role="tabpanel" aria-labelledby="documentos-tab">
                                <!-- Campos de documentación -->
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" form="formEditar" class="btn btn-primary">Guardar cambios</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal de confirmación de eliminación -->
    <div class="modal fade" id="modalEliminar" tabindex="-1" aria-labelledby="modalEliminarLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title" id="modalEliminarLabel">Confirmar eliminación</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4">
                        <i class="fas fa-exclamation-triangle text-danger" style="font-size: 4rem;"></i>
                    </div>
                    <p>¿Está seguro de que desea eliminar este expediente? Esta acción no se puede deshacer.</p>
                    <p class="fw-bold">Expediente: <?= htmlspecialchars($nombreCompleto) ?> (<?= htmlspecialchars($expediente['doi']) ?>)</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <form action="eliminar_expediente.php" method="POST">
                        <input type="hidden" name="doi" value="<?= htmlspecialchars($expediente['doi']) ?>">
                        <button type="submit" class="btn btn-danger">Eliminar permanentemente</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Scripts de Bootstrap y funcionalidades -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Inicializar tooltips de Bootstrap
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });
        
        // Función para imprimir expediente
        function imprimirExpediente() {
            window.print();
        }
        
        // Animación para historial de cambios (ejemplo)
        document.addEventListener('DOMContentLoaded', function() {
            const timelineItems = document.querySelectorAll('.timeline-item');
            timelineItems.forEach((item, index) => {
                setTimeout(() => {
                    item.style.opacity = '1';
                }, 100 * index);
            });
        });
    </script>