<?php
// Conexión a la base de datos
$servername = "localhost";
$username = "supervisor";
$password = "Pinpad2021";
$dbname = "cnjs_jptgi";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Variables para almacenar los resultados
$totalCount = 0;
$filteredCount = 0;

// Obtener el total de registros donde VIA = 2
$sqlTotal = "SELECT COUNT(*) AS total FROM exp_data WHERE VIA = 1";
$resultTotal = $conn->query($sqlTotal);
if ($resultTotal && $resultTotal->num_rows > 0) {
    $row = $resultTotal->fetch_assoc();
    $totalCount = $row['total'];
}

// Manejar filtro por rango de fechas
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $startDate = $_POST['start_date'] ?? '';
    $endDate = $_POST['end_date'] ?? '';

    if (!empty($startDate) && !empty($endDate)) {
        $sqlFiltered = "SELECT COUNT(*) AS filtered FROM exp_data WHERE VIA = 1 AND FECHA_CREACION BETWEEN ? AND ?";
        $stmt = $conn->prepare($sqlFiltered);
        $stmt->bind_param("ss", $startDate, $endDate);
        $stmt->execute();
        $resultFiltered = $stmt->get_result();
        if ($resultFiltered && $resultFiltered->num_rows > 0) {
            $row = $resultFiltered->fetch_assoc();
            $filteredCount = $row['filtered'];
        }
        $stmt->close();
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estadísticas - VIA 2</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="mb-4">Estadísticas - Canjes de Gestoria</h1>

        <div class="mb-3">
            <h4>Total de registros: <span class="badge bg-primary"><?php echo $totalCount; ?></span></h4>
        </div>

        <form method="post" class="mb-4">
            <div class="row g-3">
                <div class="col-md-5">
                    <label for="start_date" class="form-label">Fecha de inicio</label>
                    <input type="date" class="form-control" id="start_date" name="start_date" required>
                </div>
                <div class="col-md-5">
                    <label for="end_date" class="form-label">Fecha de fin</label>
                    <input type="date" class="form-control" id="end_date" name="end_date" required>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                </div>
            </div>
        </form>

        <?php if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($startDate) && !empty($endDate)): ?>
            <div class="alert alert-info">
                <strong>Resultados filtrados:</strong> <?php echo $filteredCount; ?> registros entre <?php echo $startDate; ?> y <?php echo $endDate; ?>.
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
